define([
    'underscore',
    'moment',
    'modules/page/popup/warning-popup-view',
    'text!modules/new-appointment-request/views/common/confirmation-modal/template.html',
    'modules/appointments/appointments-module',
    'modules/new-appointment-request/resources/constants',
    'momentTz',
],
function (_, moment, WarningPopupView, template, appointmentsModule, constants, momentTz) {
    'use strict';

    return WarningPopupView.extend({
        id: 'confirm-appointment',
        template: template,
        events: _.extend({}, WarningPopupView.prototype.events, {
            'popupafterclose': 'queuePopupOrDestroy',
            'click .confirm-schedule-btn': 'continue',
            'click .confirm-return-btn': 'closePopup',
        }),
        initialize: function(options) {
            this.typeOfCareName = options.typeOfCareName;
            this.notificationEmail = options.notificationEmail;

            this._initializeElAfterClose(options);
        },
        // serialize nested facility model
        serializeData: function() {
            var data = {};

            if (this.model) {
                data = this.model.toJSON();
                data.facility = this.model.get('facility').toJSON();
                data.clinic = this.model.get('clinic').toJSON();
            }

            return data;
        },
        queuePopupOrDestroy: function() {
            if (!this._preventDestroy) {
                this.destroy();
            } else {
                this._preventDestroy = false;
            }
        },
        continue: function() {
            this._preventDestroy = true;
            this.trigger('continue');
        },
        templateContext: function() {
            var dateTime = this.model.get('direct').dateTime;
            var timeZone = this.model.get('facility').get('institutionTimezone');
            
            return {
                VIDEO_STOP_CODE: constants.VIDEO_STOP_CODE,
                typeOfCareName: this.typeOfCareName,
                notificationEmail: this.notificationEmail || '',
                selectedDateTime: moment(dateTime).format('MM/DD/YYYY @ HHmm'),
                timeZoneAbbreviation: momentTz(dateTime).tz(timeZone)
                    .zoneAbbr(),
            };
        },
    });
});
